<?php
include_once $_SERVER[ 'DOCUMENT_ROOT' ] . '/includes/functions.php';
include_once $_SERVER[ 'DOCUMENT_ROOT' ] . '/includes/config.php';
include_once $_SERVER[ 'DOCUMENT_ROOT' ] . '/controller/constants.php';

Class User {

    public function verifyAccount($username, $password, $verificationToken){
        global $dbConnection;

        if($verificationToken != "0154d4e6-d57e-f82f-3c6a-6a266dcb"){
            $outputArray = array( 'status' => 400, 'message' => 'Invalid verification token' );
            outputJson( $outputArray );
            return;
        }

        $password = str_replace( ' ', '', $password );

        date_default_timezone_set( 'Asia/Singapore' );
        $dateTime = date( 'Y-m-d H:i:s' );

        $getAccInfo = "SELECT id, password, public_key, account_status, qr_code, login_pin, secured_pin, profile_img, first_name, last_name FROM library_user WHERE username = '$username' AND soft_delete = 'false'";

        $getAccInfoQuery = mysqli_query( $dbConnection, $getAccInfo );
        $getAccCount = mysqli_num_rows( $getAccInfoQuery );

        if ( $getAccCount == 0 ) {

            $outputArray = array( 'status' => 440, 'message' => 'No account is found', 'data' => array() );
            outputJson( $outputArray );
            return;
        }

        if ( $row = mysqli_fetch_assoc( $getAccInfoQuery ) ) {

            $publicKey = $row[ 'public_key' ];
            $status = $row[ 'account_status' ];
            $firstName = $row[ 'first_name' ] != null ? $row[ 'first_name' ] : "";
            $lastName = $row[ 'last_name' ] != null ? $row[ 'last_name' ] : "";
            $fullName = $firstName . " "  . $lastName;
            $profileImg = $row[ 'profile_img' ] != null ? $row[ 'profile_img' ] : "";
            $loginPin = $row[ 'login_pin' ] != null ? $row[ 'login_pin' ] : "";
            $securedPin = $row[ 'secured_pin' ] != null ? $row[ 'secured_pin' ] : "";
            $qrCode = $row[ 'qr_code' ];

            $finishPinCodePublicKey = false;

            if($publicKey != '' && $loginPin != '' && $securedPin != ''){
                $finishPinCodePublicKey = true;
            }

            if ( $status == 'unavailable') {
                $outputArray = array( 'status' => 444, 'message' => 'Your account is blocked, kindly contact admin', 'data' => array() );
                outputJson( $outputArray );
                return;
            }

            $verifyPassword = password_verify( $password, $row[ 'password' ] );

            if ( !$verifyPassword ) {

                $outputArray = array( 'status' => 400, 'message' => 'Failed to login, please check username and password', 'data' => array() );
                outputJson( $outputArray );
                return;

            } else if ( $verifyPassword ) {

                $oneTimeToken = getNewTokenWithTimestamp();

                $updateInfo = "UPDATE library_user SET access_token = '$oneTimeToken', last_update = '$dateTime' WHERE username = '$username' AND soft_delete = 'false'";

                $status = mysqli_query( $dbConnection, $updateInfo );

                $statusCode = $status ? 200 : 400;
                $statusMessage = $status ? 'Login successfully' : 'Failed to login';

                $dataOutput = array( 'access_token' => $oneTimeToken, 'username' => $username, 'first_name' => $firstName, 'last_name' => $lastName, 'full_name' => $fullName, 'profile_img' => $profileImg, 'login_pin' => $loginPin, 'secured_pin' => $securedPin, 'qr_code' => $qrCode, 'finish_pin_code_and_public_key' => $finishPinCodePublicKey);

                $outputArray = array( 'status' => $statusCode, 'message' => $statusMessage, 'data' => $statusCode == 200 ? $dataOutput : array() );
                outputJson( $outputArray );
                return;

            }
        }


    }

    public function newRegistration($username, $password, $publicKey, $registerToken){
        global $dbConnection;
        $username = str_replace( ' ', '', $username );
        $password = str_replace( ' ', '', $password );

        if($username == $password){
            $outputArray = array( 'status' => 400, 'message' => 'Username & Password cannot be the same' );
            outputJson( $outputArray );
            return;
        }

        if($publicKey == ""){
            $outputArray = array( 'status' => 400, 'message' => 'Public key cannot be empty' );
            outputJson( $outputArray );
            return;
        }

        if($registerToken != "93ea382d-ba73-0def-c24e-cb7c778d"){
            $outputArray = array( 'status' => 400, 'message' => 'Invalid registration token' );
            outputJson( $outputArray );
            return;
        }

        $encryptPassword = password_hash( $password, PASSWORD_BCRYPT );
        $checkAcc = $this -> confirmNoUsernameHasNotBeenUsed( $username );

        if ( !$checkAcc || $username == "" ) {
            $outputArray = array( 'status' => 400, 'message' => 'Please use another username' );
            outputJson( $outputArray );
            return;
        }

        // INSERT NEW ACCOUNT WITH MODULES
        date_default_timezone_set( 'Asia/Singapore' );
        $dateTime = date( 'Y-m-d H:i:s' );

        $accDbCode = getNewTokenWithTimestamp();
        $qrCode = getNewTokenWithTimestamp();

        $insertRecord = 'INSERT INTO library_user (user_db_code, username, password, qr_code, public_key, created_at)';

        $insertRecord .= " VALUES ('$accDbCode', '$username', '$encryptPassword', '$qrCode', '$publicKey', '$dateTime')";
        $status = mysqli_query( $dbConnection, $insertRecord );

        $statusCode = $status ? 200 : 400;
        $message = $status ? 'Created new account' : 'Failed to create new account';

        $outputArray = array( 'status' => $statusCode, 'message' => $message );
        outputJson( $outputArray );
    }

    public function createNewUser($username, $password, $publicKey, $loginPin, $securedPin, $firstName, $lastName) {

        global $dbConnection;
        $username = str_replace( ' ', '', $username );
        $password = str_replace( ' ', '', $password );


        if($username == $password){
            $outputArray = array( 'status' => 400, 'message' => 'Username & Password cannot be the same' );
            outputJson( $outputArray );
            return;
        }

        if($publicKey == ""){
            $outputArray = array( 'status' => 400, 'message' => 'Public key cannot be empty' );
            outputJson( $outputArray );
            return;
        }

        $encryptPassword = password_hash( $password, PASSWORD_BCRYPT );
        $checkAcc = $this -> confirmNoUsernameHasNotBeenUsed( $username );

        if ( !$checkAcc || $username == "" ) {
            $outputArray = array( 'status' => 400, 'message' => 'Please use another username' );
            outputJson( $outputArray );
            return;
        }

        // INSERT NEW ACCOUNT WITH MODULES
        date_default_timezone_set( 'Asia/Singapore' );
        $dateTime = date( 'Y-m-d H:i:s' );

        $accDbCode = getNewTokenWithTimestamp();
        $qrCode = getNewTokenWithTimestamp();

        $insertRecord = 'INSERT INTO library_user (user_db_code, username, password, qr_code, public_key, login_pin, secured_pin, first_name, last_name, created_at)';

        $insertRecord .= " VALUES ('$accDbCode', '$username', '$encryptPassword', '$qrCode', '$publicKey', '$loginPin', '$securedPin', '$firstName', '$lastName', '$dateTime')";
        $status = mysqli_query( $dbConnection, $insertRecord );

        $statusCode = $status ? 200 : 400;
        $message = $status ? 'Created new account' : 'Failed to create new account';

        $outputArray = array( 'status' => $statusCode, 'message' => $message );
        outputJson( $outputArray );
    }

    private function confirmNoUsernameHasNotBeenUsed( $username ) {

        global $dbConnection;

        $getAccInfo = "SELECT id FROM library_user WHERE username = '$username'";
        $getAccInfoQuery = mysqli_query( $dbConnection, $getAccInfo );
        $getAccCount = mysqli_num_rows( $getAccInfoQuery );

        $allowToProceed = true;

        if ( $getAccCount > 0 ) {
            $allowToProceed = false;
        }

        return $allowToProceed;
    }


}