<?php
include_once $_SERVER[ 'DOCUMENT_ROOT' ] . '/includes/functions.php';
include_once $_SERVER[ 'DOCUMENT_ROOT' ] . '/includes/config.php';
include_once $_SERVER[ 'DOCUMENT_ROOT' ] . '/controller/constants.php';

Class Admin {

    public function verifyUserToken( $username, $token ) {
        global $dbConnection;

        $getAccountInfo = "SELECT id, account_status FROM library_user WHERE acc_username = '$username' AND access_token = '$token' AND soft_delete = 'false'";
        $getAccountInfoQuery = mysqli_query( $dbConnection, $getAccountInfo );

        $getUserCount = mysqli_num_rows( $getAccountInfoQuery );

        if ( $getUserCount == 0 ) {
            return array( 'status' => 400, 'role' => 'admin' );
        }

        if ( $row = mysqli_fetch_assoc( $getAccountInfoQuery ) ) {
            $userStatus = $row[ 'account_status' ];

            if ( $userStatus == 'blocked' ) {
                return array( 'status' => 444, 'role' => 'admin' );
            }
        }
        return array( 'status' => 200, 'role' => 'admin' );
    }

    public function getPaymentModeData( $statisticsType, $username ) {
        global $dbConnection;

        $getReportData = array();

        $statisticsType = strtoupper($statisticsType);

        if ( $statisticsType == '1M' ) {
            $getReportData = $this -> getMonthlyPaymentModeData();
        } else if ( $statisticsType == '7D' ) {
            $getReportData = $this -> get7DPaymentModeData();
        }else if ( $statisticsType == '1Y' ) {
            $getReportData = $this -> get1YPaymentModeData();
        }else{
            $getReportData = $this -> getMonthlyPaymentModeData();
        }

        $outputArray = array( 'status' => 200, 'message' => 'Loaded data', 'data' => $getReportData );
        outputJson( $outputArray );

    }

    private function processPaymentData($dataList) {
        $date = [];
        $eP = [];
        $non_eP = [];
    
        // Loop through each day's data
        foreach ($dataList as $key => $values) {
            // Format the date from "Y-m-d" to "M d"
            $dateObj = DateTime::createFromFormat('Y-m-d', $key);
            $formattedDate = $dateObj->format('M d');
            $date[] = $formattedDate;
    
            // Append electronic and non-electronic payment data
            $eP[] = $values['eP'];
            $non_eP[] = $values['non_eP'];
        }
    
        // Calculate totals
        $total_eP = array_sum($eP);
        $total_non_eP = array_sum($non_eP);
    
        // Build the structured output array
        $output = [
            'date' => $date,
            'eP' => $eP,
            'non_eP' => $non_eP,
            'total_eP' => $total_eP,
            'total_non_eP' => $total_non_eP
        ];
    
        return $output;
    }
    
    public function getStatisticData( $statisticsType, $username ) {
        global $dbConnection;

        $outputData = array();

        $getInfo = $this -> getAppliciantData();
        $outputData[ 'new_applicants_today' ] = $getInfo[ 'new_applicants_today' ];
        $outputData[ 'new_applicants_this_months' ] = $getInfo[ 'new_applicants_this_months' ];
        $outputData[ 'total_applicants' ] = $getInfo[ 'total_applicants' ];

        $getApplicationInfo = $this -> getApplicationData();
        $outputData[ 'new_factoring_application_today' ] = $getApplicationInfo[ 'new_factoring_application_today' ];
        $outputData[ 'new_factoring_application_this_months' ] = $getApplicationInfo[ 'new_factoring_application_this_months' ];
        $outputData[ 'total_factoring_application' ] = $getApplicationInfo[ 'total_factoring_application' ];
        $outputData[ 'pending_factoring_applications' ] = $getApplicationInfo[ 'pending_factoring_applications' ];
        $outputData[ 'pending_signing' ] = strval( $this -> getPendingApproverCount() );

        $outputData[ 'approved_factoring_application' ] = $getApplicationInfo[ 'approved_factoring_application' ];
        $outputData[ 'pending_for_sign' ] = strval( $this -> getOwnPendingApproverCount( $username ) );
        $outputData[ 'top_contract_amounts' ] = $this -> getTop10ContactAmount();
        $outputData[ 'top_applicant_current_limit' ] = $this -> getTop10AppliciantCurrentLimit();
        $outputData[ 'top_settlement_applicant' ] = array();

        $natureCount = $this -> getApplicationNatureTypeCount();

        $outputData[ 'recurring_today' ] = strval( $natureCount[ 'recurring_today' ] );
        $outputData[ 'recurring_month' ] = strval( $natureCount[ 'recurring_month' ] );
        $outputData[ 'one_off_today' ] = strval( $natureCount[ 'one_off_today' ] );
        $outputData[ 'one_off_month' ] = strval( $natureCount[ 'one_off_month' ] );
        $outputData[ 'milestone_staggered_today' ] = strval( $natureCount[ 'milestone_staggered_today' ] );
        $outputData[ 'milestone_staggered_month' ] = strval( $natureCount[ 'milestone_staggered_month' ] );
        $outputData[ 'progress_today' ] = strval( $natureCount[ 'progress_today' ] );
        $outputData[ 'progress_month' ] = strval( $natureCount[ 'progress_month' ] );

        $getMonthData = array();

        $statisticsType = strtoupper($statisticsType);

        if ( $statisticsType == '1M' ) {
            $getMonthData = $this -> getMonthlySalesData();
        } else if ( $statisticsType == '7D' ) {
            $getMonthData = $this -> get7DaysSalesData();
        } else if ( $statisticsType == '1Y' ) {
            $getMonthData = $this -> get1YSalesData();
        }else{
            $getMonthData = $this -> getMonthlySalesData();
        }

        $outputData[ 'date' ] = $getMonthData[ 'date' ] ;
        $outputData[ 'project_income' ] = $getMonthData[ 'project_income' ] ;
        $outputData[ 'profit' ] = $getMonthData[ 'profit' ] ;
        $outputData[ 'total_project_income' ] = $getMonthData[ 'total_project_income' ] ;
        $outputData[ 'total_profit' ] = $getMonthData[ 'total_profit' ] ;

        $outputArray = array( 'status' => 200, 'message' => 'Loaded data', 'data' => $outputData );
        outputJson( $outputArray );

    }

    private function process1YData($dataList) {
        // Initialize arrays to store processed data
        $dates = [];
        $project_income = [];
        $profit = [];
    
        // First, sort the keys of dataList to ensure they are in chronological order
        ksort($dataList);
    
        foreach ($dataList as $key => $value) {
            // Convert 'Y-m' to 'M Y' format for better readability
            $dateObj = DateTime::createFromFormat('Y-m', $key);
            $formattedDate = $dateObj->format('M Y');
    
            // Add the formatted date to the dates array
            $dates[] = $formattedDate;
    
            // Convert project income and profit to string and add to their respective arrays
            $project_income[] = (float) $value['project_income'];
            $profit[] = (float) $value['profit'];
        }
    
        // Calculate totals
        $total_project_income = array_sum($project_income);
        $total_profit = array_sum($profit);
    
        // Prepare the structured output array
        return [
            'date' => $dates,
            'project_income' => $project_income,
            'profit' => $profit,
            'total_project_income' => strval($total_project_income),
            'total_profit' => strval($total_profit)
        ];
    }

    
    private function processData( $dataList ) {
        $date = [];
        $project_income = [];
        $profit = [];

        // Loop through each entry in dataList to populate arrays
        foreach ( $dataList as $key => $value ) {
            // Format date from 'Y-m-d' to 'd M'
            $dateObj = DateTime::createFromFormat( 'Y-m-d', $key );
            $formattedDate = $dateObj->format( 'd M' );

            $date[] = $formattedDate;

            // Add project income and profit
            $project_income[] = strval( $value[ 'project_income' ] );
            $profit[] = strval( $value[ 'profit' ] );
        }

        // Calculate totals
        $total_project_income = array_sum( $project_income );
        $total_profit = array_sum( $profit );

        // Return the structured array
        return [
            'date' => $date,
            'project_income' => $project_income,
            'profit' => $profit,
            'total_project_income' => strval( $total_project_income ),
            'total_profit' => strval( $total_profit )
        ];
    }

    private function get7DPaymentModeData() {
        global $dbConnection;

        date_default_timezone_set( 'Asia/Kuala_Lumpur' );

        // Set today's date
        $endDate = new DateTime(); // Today's date

        // Create a clone of today's date and subtract 7 days for the start date
        $startDate = clone $endDate;
        $startDate->modify('-7 days');
    
        // DateInterval of one day
        $interval = new DateInterval('P1D');
    
        // Create a DatePeriod, which is iterable with a foreach loop
        // We add one day to include today in the loop
        $dateRange = new DatePeriod($startDate, $interval, $endDate->modify('+1 day'));
            
        // Iterate over each date in the period
        foreach ( $dateRange as $date ) {
            // Format the date as you need, here it is Y-m-d
            $thisMonthDate = $date->format( 'Y-m-d' );
            $rawDateList[ $thisMonthDate ][ 'eP' ] = 0;
            $rawDateList[ $thisMonthDate ][ 'non_eP' ] = 0;

            $getInfo = "SELECT DATE(date_created) AS transaction_date, count(id) as total_non_ep
            FROM 
                library_application
            WHERE 
                date_created LIKE '%$thisMonthDate%' AND soft_delete = 'false' AND JSON_UNQUOTE(JSON_EXTRACT(info, '$.payment_mode.value')) = 'Non-eP'
                        GROUP BY 
                DATE(date_created)
            ORDER BY 
                DATE(date_created)";
    
            $getInfoQuery = mysqli_query( $dbConnection, $getInfo );
    
            while ( $row = mysqli_fetch_assoc( $getInfoQuery ) ) {
                $transactionDate = $row[ 'transaction_date' ];
                $totalNonEp = $row[ 'total_non_ep' ];
    
                $rawDateList[ $transactionDate ][ 'non_eP' ] = $totalNonEp;
            }


            $getInfo = "SELECT DATE(date_created) AS transaction_date, count(id) as total_ep
            FROM 
                library_application
            WHERE 
                date_created LIKE '%$thisMonthDate%' AND soft_delete = 'false' AND JSON_UNQUOTE(JSON_EXTRACT(info, '$.payment_mode.value')) = 'eP'
                        GROUP BY 
                DATE(date_created)
            ORDER BY 
                DATE(date_created)";
    
            $getInfoQuery = mysqli_query( $dbConnection, $getInfo );
    
            while ( $row = mysqli_fetch_assoc( $getInfoQuery ) ) {
                $transactionDate = $row[ 'transaction_date' ];
                $totalEp = $row[ 'total_ep' ];
    
                $rawDateList[ $transactionDate ][ 'eP' ] = $totalEp;
            }

        }

 

    

        $rawDateList = $this -> processPaymentData( $rawDateList );

        return $rawDateList;

    }

    private function get1YPaymentModeData() {
        global $dbConnection;
    
        date_default_timezone_set('Asia/Kuala_Lumpur');
    
        // Prepare the dates for the whole year
        $startDate = new DateTime('first day of January this year');
        $endDate = new DateTime('last day of December this year');
    
        // DateInterval of one month
        $interval = new DateInterval('P1M');
    
        // Adjust endDate to include the last month in iteration
        $endDate->modify('+1 day');
    
        // Create a DatePeriod
        $dateRange = new DatePeriod($startDate, $interval, $endDate);
    
        // Initialize arrays to collect monthly data
        $monthlyData = [
            'date' => [],
            'eP' => array_fill(0, 12, 0), // Pre-fill with zeros
            'non_eP' => array_fill(0, 12, 0) // Pre-fill with zeros
        ];
    
        $monthIndex = 0; // To keep track of the current month index
    
        foreach ($dateRange as $date) {
            $monthStart = $date->format('Y-m-01');
            $monthEnd = $date->format('Y-m-t');
            $monthlyData['date'][] = $date->format('M Y');
    
            // Query for non-eP payments in the month
            $getNonEP = "SELECT count(id) as total_non_ep
                        FROM library_application
                        WHERE date_created BETWEEN '$monthStart' AND '$monthEnd' AND soft_delete = 'false' AND JSON_UNQUOTE(JSON_EXTRACT(info, '$.payment_mode.value')) = 'Non-eP'";
            $nonEPResult = mysqli_query($dbConnection, $getNonEP);
            if ($row = mysqli_fetch_assoc($nonEPResult)) {
                $monthlyData['non_eP'][$monthIndex] = (int)$row['total_non_ep'];
            }
    
            // Query for eP payments in the month
            $getEP = "SELECT count(id) as total_ep
                      FROM library_application
                      WHERE date_created BETWEEN '$monthStart' AND '$monthEnd' AND soft_delete = 'false' AND JSON_UNQUOTE(JSON_EXTRACT(info, '$.payment_mode.value')) = 'eP'";
            $epResult = mysqli_query($dbConnection, $getEP);
            if ($row = mysqli_fetch_assoc($epResult)) {
                $monthlyData['eP'][$monthIndex] = (int)$row['total_ep'];
            }
    
            $monthIndex++; // Increment the month index
        }
    
        // Compute totals
        $monthlyData['total_eP'] = array_sum($monthlyData['eP']);
        $monthlyData['total_non_eP'] = array_sum($monthlyData['non_eP']);
    
        return $monthlyData;
    }
    

    private function getMonthlyPaymentModeData() {
        global $dbConnection;

        date_default_timezone_set( 'Asia/Kuala_Lumpur' );
        $todayMonth = date( 'Y-m' );

        $rawDateList = array();

        // Get the first and last day of the current month
        $firstDayOfMonth = date( 'Y-m-01' );
        // First day of the current month
        $lastDayOfMonth = date( 'Y-m-t' );
        // Last day of the current month

        // Create DateTime objects for the start and end dates
        $startDate = new DateTime( $firstDayOfMonth );
        $endDate = new DateTime( $lastDayOfMonth );

        // Add one day to the end date to include the last day in the loop
        $endDate->modify( '+1 day' );

        // DateInterval of one day
        $interval = new DateInterval( 'P1D' );

        // Create a DatePeriod, which is iterable with a foreach loop
        $dateRange = new DatePeriod( $startDate, $interval, $endDate );

        // Iterate over each date in the period
        foreach ( $dateRange as $date ) {
            // Format the date as you need, here it is Y-m-d
            $thisMonthDate = $date->format( 'Y-m-d' );
            $rawDateList[ $thisMonthDate ][ 'eP' ] = 0;
            $rawDateList[ $thisMonthDate ][ 'non_eP' ] = 0;
        }

        $getInfo = "SELECT DATE(date_created) AS transaction_date, count(id) as total_non_ep
        FROM 
            library_application
        WHERE 
            date_created LIKE '$todayMonth-%' AND soft_delete = 'false' AND JSON_UNQUOTE(JSON_EXTRACT(info, '$.payment_mode.value')) = 'Non-eP'
                    GROUP BY 
            DATE(date_created)
        ORDER BY 
            DATE(date_created)";

        $getInfoQuery = mysqli_query( $dbConnection, $getInfo );

        while ( $row = mysqli_fetch_assoc( $getInfoQuery ) ) {
            $transactionDate = $row[ 'transaction_date' ];
            $totalNonEp = $row[ 'total_non_ep' ];

            $rawDateList[ $transactionDate ][ 'non_eP' ] = $totalNonEp;
        }

        $getInfo = "SELECT DATE(date_created) AS transaction_date, count(id) as total_ep
        FROM 
            library_application
        WHERE 
            date_created LIKE '$todayMonth-%' AND soft_delete = 'false' AND JSON_UNQUOTE(JSON_EXTRACT(info, '$.payment_mode.value')) = 'eP'
                    GROUP BY 
            DATE(date_created)
        ORDER BY 
            DATE(date_created)";

        $getInfoQuery = mysqli_query( $dbConnection, $getInfo );

        while ( $row = mysqli_fetch_assoc( $getInfoQuery ) ) {
            $transactionDate = $row[ 'transaction_date' ];
            $totalEp = $row[ 'total_ep' ];

            $rawDateList[ $transactionDate ][ 'eP' ] = $totalEp;
        }

        $rawDateList = $this -> processPaymentData( $rawDateList );

        return $rawDateList;

    }

    private function get1YSalesData() {
        global $dbConnection;

        date_default_timezone_set('Asia/Kuala_Lumpur');
    
        // Prepare the dates for the whole year
        $startDate = new DateTime('first day of January this year');
        $endDate = new DateTime('last day of December this year');
    
        // DateInterval of one month
        $interval = new DateInterval('P1M');
    
        // Adjust endDate to include the last month in iteration
        $endDate->modify('+1 day');
    
        // Create a DatePeriod
        $dateRange = new DatePeriod($startDate, $interval, $endDate);
    
        // Initialize arrays to collect monthly data
        $monthlyData = [
            'date' => [],
            'eP' => array_fill(0, 12, 0), // Pre-fill with zeros
            'non_eP' => array_fill(0, 12, 0) // Pre-fill with zeros
        ];
    
        $monthIndex = 0; // To keep track of the current month index
    
        foreach ($dateRange as $date) {

            $monthStart = $date->format('Y-m-01');
            $monthEnd = $date->format('Y-m-t');

            $thisMonthDate = $date->format( 'Y-m-d' );
            $thisMonthOnly = $date->format( 'Y-m' );
            $rawDateList[ $thisMonthOnly ][ 'project_income' ] = 0.00;
            $rawDateList[ $thisMonthOnly ][ 'profit' ] = 0.00;

            $getInfo = "SELECT DATE_FORMAT(date_created, '%Y-%m') AS transaction_month, 
            SUM(JSON_EXTRACT(info, '$.project_income.total')) AS project_total,
            SUM(JSON_EXTRACT(info, '$.project_income.factoring.profit') + 
                JSON_EXTRACT(info, '$.project_income.term_advance_pre_factoring.profit')) AS total_profit
            FROM 
                library_application
            WHERE 
                date_created BETWEEN '2024-01-01' AND '2024-12-31' AND soft_delete = 'false'
            GROUP BY 
                DATE_FORMAT(date_created, '%Y-%m')
            ORDER BY 
                DATE_FORMAT(date_created, '%Y-%m');
            ";

            $getInfoQuery = mysqli_query( $dbConnection, $getInfo );
    
            while ( $row = mysqli_fetch_assoc( $getInfoQuery ) ) {
                $transactionMonth = $row[ 'transaction_month' ];
                $projectTotal = $row[ 'project_total' ];
                $totalProfit = $row[ 'total_profit' ];
    
                $rawDateList[ $transactionMonth ][ 'project_income' ] = $projectTotal;
                $rawDateList[ $transactionMonth ][ 'profit' ] = $totalProfit;
            }
    
            $monthIndex++; // Increment the month index
        }

        $rawDateList = $this -> process1YData( $rawDateList );

        return $rawDateList;
    }

    private function getMonthlySalesData() {
        global $dbConnection;

        date_default_timezone_set( 'Asia/Kuala_Lumpur' );
        $todayMonth = date( 'Y-m' );

        $rawDateList = array();

        // Get the first and last day of the current month
        $firstDayOfMonth = date( 'Y-m-01' );
        // First day of the current month
        $lastDayOfMonth = date( 'Y-m-t' );
        // Last day of the current month

        // Create DateTime objects for the start and end dates
        $startDate = new DateTime( $firstDayOfMonth );
        $endDate = new DateTime( $lastDayOfMonth );

        // Add one day to the end date to include the last day in the loop
        $endDate->modify( '+1 day' );

        // DateInterval of one day
        $interval = new DateInterval( 'P1D' );

        // Create a DatePeriod, which is iterable with a foreach loop
        $dateRange = new DatePeriod( $startDate, $interval, $endDate );

        // Iterate over each date in the period
        foreach ( $dateRange as $date ) {
            // Format the date as you need, here it is Y-m-d
            $thisMonthDate = $date->format( 'Y-m-d' );
            $rawDateList[ $thisMonthDate ][ 'project_income' ] = 0.00;
            $rawDateList[ $thisMonthDate ][ 'profit' ] = 0.00;
        }

        $getInfo = "SELECT DATE(date_created) AS transaction_date, SUM(JSON_EXTRACT(info, '$.project_income.total')) AS project_total,
        SUM(JSON_EXTRACT(info, '$.project_income.factoring.profit') + JSON_EXTRACT(info, '$.project_income.term_advance_pre_factoring.profit')) AS total_profit
        FROM 
            library_application
        WHERE 
            date_created LIKE '$todayMonth-%' AND soft_delete = 'false'
        GROUP BY 
            DATE(date_created)
        ORDER BY 
            DATE(date_created)";

        $getInfoQuery = mysqli_query( $dbConnection, $getInfo );

        while ( $row = mysqli_fetch_assoc( $getInfoQuery ) ) {
            $transactionDate = $row[ 'transaction_date' ];
            $projectTotal = $row[ 'project_total' ];
            $totalProfit = $row[ 'total_profit' ];

            $rawDateList[ $transactionDate ][ 'project_income' ] = $projectTotal;
            $rawDateList[ $transactionDate ][ 'profit' ] = $totalProfit;
        }

        $rawDateList = $this -> processData( $rawDateList );

        return $rawDateList;
    }

    private function get7DaysSalesData() {
        global $dbConnection;

        date_default_timezone_set( 'Asia/Kuala_Lumpur' );

        // Set today's date
        $endDate = new DateTime(); // Today's date

        // Create a clone of today's date and subtract 7 days for the start date
        $startDate = clone $endDate;
        $startDate->modify('-7 days');
    
        // DateInterval of one day
        $interval = new DateInterval('P1D');
    
        // Create a DatePeriod, which is iterable with a foreach loop
        // We add one day to include today in the loop
        $dateRange = new DatePeriod($startDate, $interval, $endDate->modify('+1 day'));
            
        // Example of how to use $dateRange
        foreach ($dateRange as $date) {
            // Format the date as you need, here it is Y-m-d
            $thisMonthDate = $date->format( 'Y-m-d' );
            $rawDateList[ $thisMonthDate ][ 'project_income' ] = 0.00;
            $rawDateList[ $thisMonthDate ][ 'profit' ] = 0.00;

            $getInfo = "SELECT DATE(date_created) AS transaction_date, SUM(JSON_EXTRACT(info, '$.project_income.total')) AS project_total,
            SUM(JSON_EXTRACT(info, '$.project_income.factoring.profit') + JSON_EXTRACT(info, '$.project_income.term_advance_pre_factoring.profit')) AS total_profit
            FROM 
                library_application
            WHERE 
                date_created LIKE '%$thisMonthDate%' AND soft_delete = 'false'
            GROUP BY 
                DATE(date_created)
            ORDER BY 
                DATE(date_created)";
    
            $getInfoQuery = mysqli_query( $dbConnection, $getInfo );
    
            while ( $row = mysqli_fetch_assoc( $getInfoQuery ) ) {
                $transactionDate = $row[ 'transaction_date' ];
                $projectTotal = $row[ 'project_total' ];
                $totalProfit = $row[ 'total_profit' ];
    
                $rawDateList[ $transactionDate ][ 'project_income' ] = $projectTotal;
                $rawDateList[ $transactionDate ][ 'profit' ] = $totalProfit;
            }

        }

        $rawDateList = $this -> processData( $rawDateList );
        return $rawDateList;
    }


    private function getApplicationNatureTypeCount() {
        global $dbConnection;

        // Combined SQL Query for daily and monthly counts
        $query = "
            SELECT 
                nature_type,
                SUM(CASE WHEN DATE(date_created) = CURDATE() THEN 1 ELSE 0 END) AS today_count,
                SUM(CASE WHEN YEAR(date_created) = YEAR(CURRENT_DATE()) AND MONTH(date_created) = MONTH(CURRENT_DATE()) THEN 1 ELSE 0 END) AS month_count
            FROM (
                SELECT 
                    JSON_UNQUOTE(JSON_EXTRACT(info, '$.nature_of_contract.value')) AS nature_type,
                    date_created
                FROM library_application
                WHERE soft_delete = 'false'
            ) AS derived
            GROUP BY nature_type;
        ";

        $queryResult = mysqli_query( $dbConnection, $query );
        if ( !$queryResult ) {
            // Handle query error here
            return [];
        }

        $counts = [
            'recurring_today' => 0,
            'recurring_month' => 0,
            'one_off_today' => 0,
            'one_off_month' => 0,
            'milestone_staggered_today' => 0,
            'milestone_staggered_month' => 0,
            'progress_today' => 0,
            'progress_month' => 0
        ];

        while ( $row = mysqli_fetch_assoc( $queryResult ) ) {
            $nature_type = $row[ 'nature_type' ];
            $today_count = $row[ 'today_count' ];
            $month_count = $row[ 'month_count' ];

            switch ( $nature_type ) {
                case 'recurring':
                $counts[ 'recurring_today' ] += $today_count;
                $counts[ 'recurring_month' ] += $month_count;
                break;
                case 'one_off':
                $counts[ 'one_off_today' ] += $today_count;
                $counts[ 'one_off_month' ] += $month_count;
                break;
                case 'milestone_staggered':
                $counts[ 'milestone_staggered_today' ] += $today_count;
                $counts[ 'milestone_staggered_month' ] += $month_count;
                break;
                case 'progress':
                $counts[ 'progress_today' ] += $today_count;
                $counts[ 'progress_month' ] += $month_count;
                break;
            }
        }

        return $counts;
    }

    private function filterApplicants( $applicants ) {
        $filteredResults = [];

        foreach ( $applicants as $applicant ) {
            // Convert values to integer for proper comparison
            $preFactoringLimit = ( int ) $applicant[ 'pre_factoring_current_limit' ];
            $factoringLimit = ( int ) $applicant[ 'factoring_current_limit' ];

            // Check if both limits are not zero
            if ( $preFactoringLimit !== 0 || $factoringLimit !== 0 ) {
                $filteredResults[] = $applicant;
            }
        }

        return $filteredResults;
    }

    private function getTop10AppliciantCurrentLimit() {
        global $dbConnection;

        $infoList = array();
        $getInfo = "SELECT id, company_name, current_facilities_limit
        FROM library_applicant
        WHERE soft_delete = 'false'
        ORDER BY CAST(JSON_EXTRACT(current_facilities_limit, '$.factoring.limit') AS UNSIGNED) + CAST(JSON_EXTRACT(current_facilities_limit, '$.pre_factoring.limit') AS UNSIGNED) DESC
        LIMIT 10";
        $getInfoQuery = mysqli_query( $dbConnection, $getInfo );

        while ( $row = mysqli_fetch_assoc( $getInfoQuery ) ) {

            $currentFacilitiesLimit = json_decode( $row[ 'current_facilities_limit' ], true );

            $tempInfo = array();
            $tempInfo[ 'applicant' ] = $row[ 'company_name' ];
            $tempInfo[ 'pre_factoring_current_limit' ] = strval( $currentFacilitiesLimit[ 'factoring' ][ 'limit' ] );
            $tempInfo[ 'factoring_current_limit' ] = strval( $currentFacilitiesLimit[ 'pre_factoring' ][ 'limit' ] );
            $infoList[] = $tempInfo;
        }

        $infoList = $this -> filterApplicants( $infoList );

        return $infoList;

    }

    private function getTop10ContactAmount() {
        global $dbConnection;

        $infoList = array();
        $getInfo = "SELECT id, info FROM library_application WHERE soft_delete = 'false' ORDER by JSON_EXTRACT(info, '$.contract_amount') DESC LIMIT 10";
        $getInfoQuery = mysqli_query( $dbConnection, $getInfo );

        while ( $row = mysqli_fetch_assoc( $getInfoQuery ) ) {
            $dataInfo = json_decode( $row[ 'info' ], true );

            $tempInfo = array();
            $tempInfo[ 'applicant' ] = $dataInfo[ 'applicant' ][ 'company_name' ];
            $tempInfo[ 'contract_amount' ] = $dataInfo[ 'contract_amount' ];
            $tempInfo[ 'contract_tenure' ] = $dataInfo[ 'contract_tenure' ] == '' ? '-' : $dataInfo[ 'contract_tenure' ]  ;

            $infoList[] = $tempInfo;
        }

        return $infoList;

    }

    private function getApplicationData() {

        global $dbConnection;

        $infoArray = array();

        $getInfo = "SELECT
        ( SELECT COUNT( * ) FROM library_application WHERE soft_delete = 'false' AND date( date_created ) = CURDATE() ) AS new_factoring_application_today,
        ( SELECT COUNT( * ) FROM library_application WHERE soft_delete = 'false' AND  YEAR( date_created ) = YEAR( CURRENT_DATE ) AND MONTH( date_created ) = MONTH( CURRENT_DATE ) ) AS new_factoring_application_this_months,
        ( SELECT COUNT( * ) FROM library_application WHERE soft_delete = 'false') AS total_factoring_application ,
        ( SELECT COUNT( * ) FROM library_application WHERE soft_delete = 'false' AND status = 'pending' ) AS pending_factoring_applications,
        ( SELECT COUNT( * ) FROM library_application WHERE soft_delete = 'false' AND status = 'approved' ) AS approved_factoring_application";

        $getInfoQuery = mysqli_query( $dbConnection, $getInfo );

        if ( $row = mysqli_fetch_assoc( $getInfoQuery ) ) {
            $infoArray = $row;
        }

        return $infoArray;
    }

    private function getOwnPendingApproverCount( $username ) {
        global $dbConnection;

        $getInfo = "
            SELECT COUNT(*) as pending_sign_count FROM library_application
            WHERE 
            (JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.approver1')) = '$username' AND JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.approver1_status')) = '')
            OR (JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.approver2')) = '$username' AND JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.approver2_status')) = '')
            OR (JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.recommender1')) = '$username' AND JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.recommender1_status')) = '')
            OR (JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.recommender2')) = '$username' AND JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.recommender2_status')) = '')
            OR (JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.due_diligence1')) = '$username' AND JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.due_diligence1_status')) = '')
            OR (JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.due_diligence2')) = '$username' AND JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.due_diligence2_status')) = '')
            AND soft_delete = 'false'
        ";

        $getInfoQuery = mysqli_query( $dbConnection, $getInfo );
        $getCount = mysqli_num_rows( $getInfoQuery );
      
        if($getCount == 0){
            return 0;
        }else{
            if ( $row = mysqli_fetch_assoc( $getInfoQuery ) ) {
                return $row['pending_sign_count'];
            }
        }
    }

    private function getPendingApproverCount() {
        global $dbConnection;

        $getInfo = "SELECT id FROM library_application WHERE JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.approver1_status')) = '' AND soft_delete = 'false'";
        $getInfoQuery = mysqli_query( $dbConnection, $getInfo );
        $getCount1 = mysqli_num_rows( $getInfoQuery );

        $getInfo2 = "SELECT id FROM library_application WHERE JSON_UNQUOTE(JSON_EXTRACT(sign_status_info, '$.approver2_status')) = '' AND soft_delete = 'false'";
        $getInfo2Query = mysqli_query( $dbConnection, $getInfo2 );
        $getCount2 = mysqli_num_rows( $getInfo2Query );

        return $getCount1 + $getCount2;

    }

    private function getAppliciantData() {
        global $dbConnection;

        $infoArray = array();

        $getInfo = "SELECT 
        (SELECT COUNT(*) FROM library_applicant WHERE soft_delete = 'false' AND date(created_at) = CURDATE()) AS new_applicants_today,
        (SELECT COUNT(*) FROM library_applicant WHERE soft_delete = 'false' AND YEAR(created_at) = YEAR(CURRENT_DATE) AND MONTH(created_at) = MONTH(CURRENT_DATE)) AS new_applicants_this_months,
        (SELECT COUNT(*) FROM library_applicant WHERE soft_delete = 'false' ) AS total_applicants ";
        $getInfoQuery = mysqli_query( $dbConnection, $getInfo );

        if ( $row = mysqli_fetch_assoc( $getInfoQuery ) ) {
            $infoArray = $row;
        }

        return $infoArray;

    }

}